IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_xParam]') 
                   and [type] = 'FN')
BEGIN
	DROP FUNCTION [dbo].[CF_xParam]
END
GO

CREATE FUNCTION [dbo].[CF_xParam](@pId_Parametro VARCHAR(20))
RETURNS VARCHAR(8000)
AS
BEGIN

DECLARE @Valor_Parametro VARCHAR(8000)
DECLARE @TipoDato VARCHAR(10)

SET @TipoDato = (SELECT MAX(ISNULL(TipoDato,'')) FROM xParametros WHERE IdParametro = @pId_Parametro)

IF (@TipoDato = '')
BEGIN
	RETURN ''
END

IF(@TipoDato = 'DECIMAL')
BEGIN
	SET @Valor_Parametro = ISNULL((SELECT CONVERT(VARCHAR(8000), Valor_Decimal) FROM xParametros WHERE IdParametro = @pId_Parametro), '0')
END

IF(@TipoDato = 'TIME')
BEGIN
	SET @Valor_Parametro = ISNULL((SELECT CONVERT(VARCHAR(8000), Valor_Time, 121) FROM xParametros WHERE IdParametro = @pId_Parametro), '1900-01-01 00:00:00.000')
END

IF(@TipoDato = 'MEMO')
BEGIN
	SET @Valor_Parametro = ISNULL((SELECT CONVERT(VARCHAR(8000), Valor_Memo) FROM xParametros WHERE IdParametro = @pId_Parametro), '')
END

IF(@TipoDato = 'DATE')
BEGIN
	SET @Valor_Parametro = ISNULL((SELECT CONVERT(VARCHAR(8000), Valor_Date, 121) FROM xParametros WHERE IdParametro = @pId_Parametro), '1900-01-01 00:00:00.000')
END

IF(@TipoDato = 'STRING')
BEGIN
	SET @Valor_Parametro = ISNULL((SELECT CONVERT(VARCHAR(8000), Valor_String) FROM xParametros WHERE IdParametro = @pId_Parametro), '')
END

IF(@TipoDato = 'INTEGER')
BEGIN
	SET @Valor_Parametro = ISNULL((SELECT CONVERT(VARCHAR(8000), Valor_Integer) FROM xParametros WHERE IdParametro = @pId_Parametro), '0')
END

IF(@TipoDato = 'FOLDER')
BEGIN
	SET @Valor_Parametro = ''
END

RETURN ISNULL(@Valor_Parametro,'')
END

GO


